# Contributions are welcome!

## Quick guide:

 * Fork the repo.
 * Create branch, e.g. feature-foo or bugfix-bar.
 * Make changes.
 * If you are adding functionality or fixing a bug - add a spec!
 * Check if specs pass.

## Creating a new Specification

If you have a new specification that you think should be a part of this repository, submit a PR and we will happily
evaluate it. There are some things that you should include in your PR.

 * Your specification class under the appropriate namespace
 * A PHPSpec spec (Try to write one, we will help you if you have trouble)
 * A factory function

## Project's standards:

 * [PSR-0: Autoloading Standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-0.md)
 * [PSR-1: Basic Coding Standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-1-basic-coding-standard.md)
 * [PSR-2: Coding Style Guide](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)
 * [Symfony Coding Standards](http://symfony.com/doc/current/contributing/code/standards.html)
 * Keep the order of class elements: static properties, instance properties, constructor, destructor, static methods, instance methods, magic static methods, magic instance methods.
